
def noneOrEmpty(value):
    return (value is None) or (value == '')

def isWebModule(id):
    return id.find('#WebModuleDeployment_') != -1

def toConfigIdList(spaceSeparatedIdList):
    # input format '[id id id ...]'
    # strings.strip(chars) not available in Python 2.1
    return spaceSeparatedIdList.replace('[', '').replace(']', '').split(' ')

installArgs = ['-appname', deployed.name]

# if this is not a WAR deployment, the contextroot property will not be present on the deployed
if hasattr(deployed, 'contextRoot'):
    installArgs.extend(['-contextroot', deployed.contextRoot])

targets = "WebSphere:cell=%s,%s=%s" % (deployed.container.cellName, deployed.container.wasTargetType, deployed.container.name)

# if this is an EJB deployment, the webServers property will not be present on the deployed
if hasattr(deployed, 'webServers'):
    for ws in deployed.webServers:
        targets += "+WebSphere:cell=%s,node=%s,server=%s" % (ws.node.cellName,ws.node.name,ws.name)

servermappings = []
servermappings.append(['.*', '.*', targets])
installArgs.extend(['-MapModulesToServers', servermappings])

vhostmappings = []
if hasattr(deployed, 'virtualHost') and deployed.virtualHost != None:
    vhostmappings.append(['.*', '.*', deployed.virtualHost.name])
else:
    vhostmappings.append(['.*', '.*', 'default_host'])
installArgs.extend(['-MapWebModToVH', vhostmappings])

if len(deployed.sharedLibraries) > 0:
    sharedLibraryMappings = []
    sharedLibNames = ''
    for l in deployed.sharedLibraries:
        sharedLibNames += '+' + l.name
    sharedLibraryMappings.append(['.*', '.*', sharedLibNames])
    installArgs.extend(['-MapSharedLibForMod', sharedLibraryMappings])
    
if hasattr(deployed, 'roleMappings'):
    roleMappings = []
    for role, group in deployed.roleMappings.items():
        # special case - allow specification of 'All Role' without requiring spaces
        if role == 'All':
            role = 'All Role'
        if group == 'Everyone':
            roleMappings.append([role, 'Yes', 'No', '', ''])
        elif group == 'AllAuthenticated':
            roleMappings.append([role, 'No', 'Yes', '', ''])
        elif group == 'AllAuthenticatedInTrustedRealms':
            roleMappings.append([role, 'No', 'No', '', '', 'Yes', '', ''])
        else:
            roleMappings.append([role, 'No', 'No', '', group])
    if hasattr(deployed, 'roleUserMappings'):
        for role, user in deployed.roleUserMappings.items():
            roleMappings.append([role, 'No', 'No', user, ''])
    if len(roleMappings) > 0:
        installArgs.extend(['-MapRolesToUsers', roleMappings])

if hasattr(deployed, 'runAsRoleMappings'):
	runAsRoleMappings = []
	for roleUser in deployed.runAsRoleMappings.keys():
		if roleUser.endswith("_user"):
			role = roleUser[:roleUser.rindex("_user")]
			user = deployed.runAsRoleMappings[roleUser]
			pwd = deployed.runAsRoleMappings["%s_password" % role]
			if noneOrEmpty(pwd):
				print "ERROR:", roleUser, "defined in runAsRoleMappings property must have a matching %s_password entry" % role
				sys.exit(1)
			runAsRoleMappings.append([role, user, pwd])
	if len(runAsRoleMappings) > 0:
		installArgs.extend(['-MapRunAsRolesToUsers', runAsRoleMappings])


# if this is an EJB deployment, the preCompileJsps property will not be present on the deployed
if hasattr(deployed, 'preCompileJsps') and deployed.preCompileJsps:
    installArgs.extend(['-preCompileJSPs','-JSPCompileOptions', [['.*', '.*', 'jspcp', 'Yes', 15, 'No']]])

# again, not present for EJB deployments
if hasattr(deployed, 'enableJspClassReloading'):
    if deployed.enableJspClassReloading and not(noneOrEmpty(deployed.jspReloadInterval)):
        installArgs.extend(['-JSPReloadForWebMod', [['.*', '.*', 'Yes', str(deployed.jspReloadInterval)]]])
    else:
        installArgs.extend(['-JSPReloadForWebMod', [['.*', '.*', 'No', '']]])

# optionally, specify a custom directory to store the installed module (if set on the was.Container)
if hasattr(deployed.container, 'moduleDestination') and deployed.container.moduleDestination != None:
    installArgs.extend(['-installed.ear.destination', deployed.container.moduleDestination])

# optionally, specify a custom directory to store the installed module (if set on the was.Module)
if hasattr(deployed, 'moduleDestination') and deployed.moduleDestination != None:
    installArgs.extend(['-installed.ear.destination', deployed.moduleDestination])

if hasattr(deployed, 'additionalInstallFlags'):
    for f in deployed.additionalInstallFlags:
        installArgs.append(f)

print "Deploying application", deployed.name, "with args: %s" % (installArgs)
AdminApp.install(deployed.file, installArgs)

deployment = AdminConfig.getid('/Deployment:%s' % (deployed.name))
deployedObject = AdminConfig.showAttribute(deployment, 'deployedObject')

# if this is not an EAR deployment, the startingWeight property will not be present on the deployed
if hasattr(deployed, 'startingWeight'):
    AdminConfig.modify(deployedObject, [['startingWeight', str(deployed.startingWeight)]])

if hasattr(deployed, 'classloaderMode'):
    if not(noneOrEmpty(deployed.classloaderMode)):
        classLoaderAttr = AdminConfig.showAttribute(deployedObject, 'classloader')
        print "Setting application classloader to %s" % (deployed.classloaderMode)
        AdminConfig.modify(classLoaderAttr, [['mode', deployed.classloaderMode]])

if hasattr(deployed, 'webModuleSessionTimeout'):
    if not(noneOrEmpty(deployed.webModuleSessionTimeout)):
        for module in toConfigIdList(AdminConfig.showAttribute(deployedObject, 'modules')):
            if isWebModule(module):
                AdminConfig.create('WebModuleConfig', module, [['sessionManagement', [['enable', 'true'], ['tuningParams', [['invalidationTimeout', str(deployed.webModuleSessionTimeout)]]]]]])

if hasattr(deployed, 'warClassloaderMode'):
    if not(noneOrEmpty(deployed.warClassloaderMode)):
        for module in toConfigIdList(AdminConfig.showAttribute(deployedObject, 'modules')):
            if isWebModule(module):
                warName = AdminConfig.showAttribute(module, 'uri')
                print "Setting WAR classloader for '%s' to %s" % (warName, deployed.warClassloaderMode)
                AdminConfig.modify(module, [['classloaderMode', deployed.warClassloaderMode]])            
