package com.xebialabs.deployit.plugin.sql.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.sql.support.VelocityUtils;


@SuppressWarnings("serial")
@ConfigurationItem(description = "SQL Oracle database instance")
public class MySqlDatabase extends Database {

	@ConfigurationItemProperty(required = false, label = "MySqlPath", description = "Path to mysql, ex /usr/bin")
	private String mysqlPath;

	@ConfigurationItemProperty(required = false, description = "target host where mysql is running")
	private Host targetHost;

	@ConfigurationItemProperty(required = false, label = "port", description = "listener's port, default 3306")
	private int port = 3306;

	public String getMysqlPath() {
		return mysqlPath;
	}

	public void setMysqlPath(String mysqlPath) {
		this.mysqlPath = mysqlPath;
	}

	@Override
	public String getCommand() {
		final String os = getHost().getOperatingSystemFamily().toString().toLowerCase();
		return VelocityUtils.evaluateTemplate(this, "com/xebialabs/deployit/plugin/sql/mysql/" + os + "_template.vm");
	}

	public Host getTargetHost() {
		return targetHost;
	}

	public void setTargetHost(Host targetHost) {
		this.targetHost = targetHost;
	}


	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}
}
