package com.xebialabs.deployit.plugin.sql.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.plugin.sql.support.VelocityUtils;
import org.apache.commons.lang.StringUtils;


@SuppressWarnings("serial")
@ConfigurationItem(description = "SQL Oracle database instance")
public class OracleDatabase extends Database {

	@ConfigurationItemProperty(required = true, label = "OracleHome", description = "OracleHome")
	private String oracleHome;

	@ConfigurationItemProperty(required = false, label = "port", description = "listener's port")
	private int port;

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getOracleHome() {
		return oracleHome;
	}

	public void setOracleHome(String oracleHome) {
		this.oracleHome = oracleHome;
	}

	@Override
	public String getCommand() {
		if (StringUtils.isNotBlank(super.getCommand())) {
			return super.getCommand();
		}
		final String os = getHost().getOperatingSystemFamily().toString().toLowerCase();
		return VelocityUtils.evaluateTemplate(this,"com/xebialabs/deployit/plugin/sql/oracle/"+ os +"_template.vm");
	}

}
