/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.rest.view.InvocationDiffView;
import com.xebialabs.deployit.core.rest.view.InvocationOutput;
import com.xebialabs.deployit.core.rest.view.PreviewResult;
import com.xebialabs.deployit.engine.api.dto.ChangeSetDto;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.DryRunDeploymentDto;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

@CliObject(name="stitch")
@ClassHelp(description="Access to stitch dry-run service.")
public class StitchClient
extends DocumentedObject {
    private ProxiesInstance proxies;

    public StitchClient() {
    }

    public StitchClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    private List<String> getStitchRules(List<File> stitchFiles) {
        return stitchFiles.stream().map(file -> {
            String string;
            FileInputStream stitchFile = new FileInputStream((File)file);
            try {
                string = IOUtils.toString((InputStream)stitchFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stitchFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Cannot open or read [%s]", file.toString()), e);
                }
            }
            stitchFile.close();
            return string;
        }).collect(Collectors.toList());
    }

    private List<String> getStitchRules(String directory) {
        Path dirPath = Paths.get(directory, new String[0]);
        if (Files.isDirectory(dirPath, new LinkOption[0])) {
            try {
                List<File> stitchFiles = Files.walk(dirPath, new FileVisitOption[0]).filter(path -> {
                    String filename = path.getFileName().toString();
                    if (!RepositoryCrawler.stitchDeclarationFilePrefixes().exists(filename::startsWith)) return false;
                    if (!RepositoryCrawler.stitchDeclarationFileSuffixes().exists(filename::endsWith)) return false;
                    return true;
                }).map(Path::toFile).collect(Collectors.toList());
                return this.getStitchRules(stitchFiles);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error reading [%s]", dirPath.toString()), e);
            }
        }
        throw new IllegalStateException(String.format("Provided path is not a directory [%s]", dirPath.toString()));
    }

    @MethodHelp(description="Validate defined stitch rules.", parameters={@ParameterHelp(name="stitchRules", description="List of stitch rules YAMLs.")}, returns="List of validation or parsing errors for given rules. Empty list if there are no formatting or validation errors")
    public List<String> validateRules(List<String> stitchRules) {
        return this.proxies.getDryRunResource().validateRules(stitchRules);
    }

    @MethodHelp(description="Validate defined stitch rules.", parameters={@ParameterHelp(name="stitchFilePaths", description="List of stitch rule file paths.")}, returns="List of validation or parsing errors for given rules. Empty list if there are no formatting or validation errors")
    public List<String> validateRuleFiles(List<String> stitchFilePaths) {
        List<String> stitchRules = this.getStitchRules(stitchFilePaths.stream().map(File::new).collect(Collectors.toList()));
        return this.validateRules(stitchRules);
    }

    @MethodHelp(description="Validate defined stitch rules.", parameters={@ParameterHelp(name="stitchDirectoryPath", description="Path to directory containing stitch rule files. Filtered by name stitch-rules*.y(a)ml")}, returns="List of validation or parsing errors for given rules. Empty list if there are no formatting or validation errors")
    public List<String> validateRuleFromDirectory(String stitchDirectoryPath) {
        List<String> stitchRules = this.getStitchRules(stitchDirectoryPath);
        return this.validateRules(stitchRules);
    }

    @MethodHelp(description="Run a dry-run for given deployment and list of Stitch rules YAMLs.", parameters={@ParameterHelp(name="deployment", description="The deployment to run dry-run with."), @ParameterHelp(name="stitchRules", description="A list of stitch rules YAML documents.")}, returns="Map of stitch invocations with information about differences and used processors list.")
    public PreviewResult dryRun(Deployment deployment, List<String> stitchRules) {
        return this.proxies.getDryRunResource().dryRun(new DryRunDeploymentDto(stitchRules, deployment));
    }

    @MethodHelp(description="Run a dry-run for given deployment and source branch.", parameters={@ParameterHelp(name="deployment", description="The deployment to run dry-run with."), @ParameterHelp(name="sourceId", description="A source CI ID we want to run dry-run against."), @ParameterHelp(name="branchName", description="Branch name against which we want to run dry-run against.")}, returns="Map of stitch invocations with information about differences and used processors list.")
    public PreviewResult dryRun(Deployment deployment, String sourceId, String branchName) {
        return this.proxies.getDryRunResource().dryRun(new DryRunDeploymentDto(new ChangeSetDto(sourceId, branchName), deployment));
    }

    @MethodHelp(description="Run a dry-run for given deployment and list of Stitch rules YAMLs.", parameters={@ParameterHelp(name="deployment", description="The deployment to run dry-run with."), @ParameterHelp(name="stitchFilePaths", description="A list of stitch rule file paths containing YAML documents.")}, returns="Map of stitch invocations with information about differences and used processors list.")
    public PreviewResult dryRunRuleFileList(Deployment deployment, List<String> stitchFilePaths) {
        List<String> stitchRules = this.getStitchRules(stitchFilePaths.stream().map(File::new).collect(Collectors.toList()));
        return this.dryRun(deployment, stitchRules);
    }

    @MethodHelp(description="Run a dry-run for given deployment and list of Stitch rules YAMLs.", parameters={@ParameterHelp(name="deployment", description="The deployment to run dry-run with."), @ParameterHelp(name="ruleDirPath", description="A directory containing stitch rule files.")}, returns="Map of stitch invocations with information about differences and used processors list.")
    public PreviewResult dryRunRuleDirectory(Deployment deployment, String ruleDirPath) {
        List<String> stitchRules = this.getStitchRules(ruleDirPath);
        return this.dryRun(deployment, stitchRules);
    }

    @MethodHelp(description="Show diff for given deployed it's invocation and processor run. The dryRunId should be used fromprevious executed dry-run together with invocation index and processorId. Dry runs are kept in cache - on cache eviction or timeout dry run has to be re-run", parameters={@ParameterHelp(name="deployedName", description="Deployment name used as key for a dry run map."), @ParameterHelp(name="invocationId", description="Index number of invocation in a list of invocations returned for a deploymentName."), @ParameterHelp(name="processorId", description="UUID of processor for which we want to show diff for."), @ParameterHelp(name="deployment", description="Deployment used in original dry-run."), @ParameterHelp(name="sourceId", description="A source CI ID we want to run dry-run against."), @ParameterHelp(name="branchName", description="Branch name against which we want to run dry-run against.")}, returns="A result of changes made for given processor with original and modified document.")
    public InvocationDiffView dryRunWithBreakpoint(String deployedName, Integer invocationId, String processorId, Deployment deployment, String sourceId, String branchName) {
        return this.proxies.getDryRunResource().dryRun(deployedName, invocationId.intValue(), UUID.fromString(processorId), new DryRunDeploymentDto(new ChangeSetDto(sourceId, branchName), deployment));
    }

    @MethodHelp(description="Show diff for original and modified document.", parameters={@ParameterHelp(name="original", description="Original document."), @ParameterHelp(name="modified", description="Modified document.")}, returns="A humane readable difference string highlighting changes between two strings.")
    public String dryRunDiff(String original, String modified) {
        return this.proxies.getDryRunResource().diff(new InvocationOutput(original, modified));
    }

    @MethodHelp(description="Run a stitch preview for given deployment.", parameters={@ParameterHelp(name="deployment", description="The deployment to run dry-run with.")}, returns="Map of stitch invocations with information about differences and used processors list.")
    public PreviewResult preview(Deployment deployment) {
        return this.proxies.getPreviewResource().preview(deployment);
    }
}

