/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp;

import com.xebialabs.overthere.gcp.GenerateSshKey;
import com.xebialabs.overthere.gcp.SshKeyPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Base64;

class JavaSecurityGenerateSshKey
implements GenerateSshKey {
    JavaSecurityGenerateSshKey() {
    }

    private static String encodePrivateKey(PrivateKey privateKey) {
        return "-----BEGIN RSA PRIVATE KEY-----" + "\n" + new String(Base64.encodeBase64((byte[])privateKey.getEncoded())) + "\n" + "-----END RSA PRIVATE KEY-----" + "\n";
    }

    private static String encodePublicKey(RSAPublicKey key, String username) throws IOException {
        return "ssh-rsa " + new String(Base64.encodeBase64((byte[])JavaSecurityGenerateSshKey.encodePublicKeyBytes(key)), StandardCharsets.UTF_8) + " " + username;
    }

    private static byte[] encodePublicKeyBytes(RSAPublicKey key) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] sshrsa = new byte[]{0, 0, 0, 7, 115, 115, 104, 45, 114, 115, 97};
        out.write(sshrsa);
        BigInteger e = key.getPublicExponent();
        byte[] data = e.toByteArray();
        JavaSecurityGenerateSshKey.encodeUInt32(data.length, out);
        out.write(data);
        BigInteger m = key.getModulus();
        data = m.toByteArray();
        JavaSecurityGenerateSshKey.encodeUInt32(data.length, out);
        out.write(data);
        return out.toByteArray();
    }

    private static void encodeUInt32(int value, OutputStream out) throws IOException {
        byte[] tmp = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.write(tmp);
    }

    @Override
    public SshKeyPair generate(String username, int keySize) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(keySize);
            KeyPair key = keyGen.generateKeyPair();
            PrivateKey priv = key.getPrivate();
            PublicKey pub = key.getPublic();
            String privateKeyString = JavaSecurityGenerateSshKey.encodePrivateKey(priv);
            String publicKeyString = JavaSecurityGenerateSshKey.encodePublicKey((RSAPublicKey)pub, username);
            return new SshKeyPair(username, privateKeyString, publicKeyString, "");
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

