/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.xebialabs.deployit.core.api.resteasy.InternalServerErrorClientResponseInterceptor;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;

class ResponseExtractor {
    private final ClientResponse<?> response;

    public static <T> T getEntity(Response response) {
        return new ResponseExtractor(response).getEntity();
    }

    public ResponseExtractor(Response response) {
        if (!(response instanceof ClientResponse)) {
            throw new IllegalArgumentException("Not a client response: " + response);
        }
        this.response = (ClientResponse)response;
        this.checkResponse();
    }

    private void checkResponse() {
        int status = this.response.getStatus();
        if (this.isNotOkStatus(status)) {
            new InternalServerErrorClientResponseInterceptor().handle(this.response);
        }
    }

    private boolean isNotOkStatus(int status) {
        return 399 < status && status < 699;
    }

    public <T> T getEntity() {
        return (T)((BaseClientResponse)this.response).getEntity();
    }

    public boolean isValidResponse() {
        return !this.isNotOkStatus(this.response.getStatus());
    }
}

