package com.xebialabs.deployit.client.logger;

import com.xebialabs.deployit.client.DeploymentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class Slf4jDeploymentListener extends AbstractDeploymentListener implements DeploymentListener {

	private final Logger logger;

	public Slf4jDeploymentListener(Class<?> clazz) {
		logger = LoggerFactory.getLogger(clazz);
	}

	@Override
	public void handleDebug(String message) {
		logger.debug(message);
	}

	@Override
	public void handleInfo(String message) {
		logger.info(message);
	}

	@Override
	public void handleTrace(String message) {
		logger.trace(message);
	}

	@Override
	public void handleError(String message) {
		logger.error(message);
	}
}
