/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.client.Deployable;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.client.DeploymentListener;
import com.xebialabs.deployit.client.Packager;
import com.xebialabs.deployit.client.logger.Slf4jDeploymentListener;
import com.xebialabs.deployit.client.utils.Files;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DarPackager
implements Packager {
    private final DeploymentListener listener;
    private final Manifest manifest = new Manifest();
    private final File workingDirectory;
    private final File darFile;

    public DarPackager(String application, String version, File targetDirectory, DeploymentListener listener) {
        this(application, version, targetDirectory, listener, version);
    }

    public DarPackager(String application, String version, File targetDirectory, DeploymentListener listener, String ciVersion) {
        this.listener = listener != null ? listener : new Slf4jDeploymentListener(DeployitCli.class);
        this.workingDirectory = new File(targetDirectory, "deployit-working-dir");
        this.darFile = new File(targetDirectory, String.format("%s-%s.dar", application, version));
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Deployit-Package-Format-Version", "1.3");
        mainAttributes.putValue("CI-Application", application);
        mainAttributes.putValue("CI-Version", ciVersion);
    }

    @Override
    public void addDeployable(Deployable deployable) {
        this.listener.debug("Add deployable " + deployable);
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = new Attributes();
        attributes.putValue("CI-Type", deployable.getType());
        attributes.putValue("CI-Name", deployable.getName());
        for (Map.Entry<String, String> me : deployable.getValues().entrySet()) {
            attributes.putValue(me.getKey(), me.getValue());
        }
        entries.put(deployable.getEntryName(), attributes);
        if (!deployable.getTags().isEmpty()) {
            int idx = 0;
            for (String tag : deployable.getTags()) {
                attributes.putValue("CI-tags-EntryValue-" + idx, tag);
                ++idx;
            }
        }
        if (deployable.getLocation() != null) {
            File location = deployable.getLocation();
            if (location.isFile()) {
                this.listener.debug(String.format(" copy file %s to %s", location, this.workingDirectory));
                Files.copyFileTo(location, this.workingDirectory);
            } else {
                this.listener.debug(String.format(" copy dir  %s to %s", location, this.workingDirectory));
                Files.copyDirectoryTo(location, this.workingDirectory);
            }
            if (!location.getName().equals(deployable.getEntryName())) {
                File oldName = new File(this.workingDirectory, location.getName());
                File newName = new File(this.workingDirectory, deployable.getEntryName());
                this.listener.debug(String.format(" rename %s to %s", oldName, newName));
                Files.rename(oldName, newName);
            }
        }
    }

    @Override
    public void addDeployables(Deployable ... deployables) {
        for (Deployable deployable : deployables) {
            this.addDeployable(deployable);
        }
    }

    @Override
    public void addDeployables(Collection<? extends Deployable> deployables) {
        for (Deployable deployable : deployables) {
            this.addDeployable(deployable);
        }
    }

    @Override
    public File perform() {
        Files.jar(this.darFile, this.workingDirectory, this.generateManifestFile());
        return this.darFile;
    }

    private File generateManifestFile() {
        File meta_inf = new File(this.workingDirectory, "META-INF");
        meta_inf.mkdirs();
        File manifestFile = new File(meta_inf, "MANIFEST.MF");
        this.listener.info("Generate manifest file " + manifestFile.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            this.dumpManifest();
            fos = new FileOutputStream(manifestFile);
            this.manifest.write(fos);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("generation of the manifest file failed", e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fos);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)fos);
        return manifestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpManifest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.manifest.write(baos);
        }
        finally {
            Closeables.closeQuietly((Closeable)baos);
        }
        this.listener.debug(new String(baos.toByteArray()));
    }
}

