/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImportHelper {
    private static final Logger logger = LoggerFactory.getLogger(ImportHelper.class);
    private Proxies proxies;

    ImportHelper(Proxies proxies) {
        this.proxies = proxies;
    }

    public ConfigurationItem doImport(String packageToImport) {
        try {
            URL url = new URL(packageToImport);
            if (url.getProtocol().equals("file")) {
                return this.processFilePath(url.getFile());
            }
            return this.proxies.getPackageService().fetch(packageToImport);
        }
        catch (MalformedURLException e) {
            return this.processFilePath(packageToImport);
        }
    }

    private ConfigurationItem processFilePath(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                FileUpload fileUpload = new FileUpload();
                fileUpload.setFileData((InputStream)new FileInputStream(file));
                return this.proxies.getPackageService().upload(file.getName(), fileUpload);
            }
            catch (IOException e) {
                logger.error("The file '{}' exists, but could not be read for upload; perhaps it's not an archive.", (Object)file.toString());
                return null;
            }
        }
        if (!file.isAbsolute()) {
            return this.proxies.getPackageService().importPackage(path);
        }
        logger.error("The file '{}' does not exist at the given absolute path", (Object)file.toString());
        return null;
    }
}

