package com.xebialabs.deployit.client;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static java.lang.String.format;

public class Authentication {
	private String username;
	public String password;

	private HttpClient httpClient;

	public Authentication(ConnectionOptions options) {
		username = options.getUsername();
		password = options.getPassword();
		init(options);
	}

	private void init(final ConnectionOptions options) {
		httpClient = new HttpClient();
		addCredentials();
		httpClient.getParams().setAuthenticationPreemptive(true);
		httpClient.getParams().setConnectionManagerTimeout(10000);
		HostConfiguration hostConfiguration = new HostConfiguration();
		hostConfiguration.setHost(options.getHost(), options.getPort(), format("http%s", options.isSecured() ? "s" : ""));
		httpClient.setHostConfiguration(hostConfiguration);
	}

	private void addCredentials() {
		final UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
		httpClient.getState().setCredentials(AuthScope.ANY, credentials);
	}

	public void logout() {
		this.username = null;
		this.password = null;
		httpClient.getState().clearCookies();
		httpClient.getState().clearCredentials();
	}

	public String getUsername() {
		return this.username;
	}

	public void loginAs(String username, String password) {
		if (httpClient.getState().getCredentials(AuthScope.ANY) != null) {
			logger.error("You're still logged in as another user, please logout first.");
			return;
		}

		this.username = username;
		this.password = password;

		addCredentials();
		httpClient.getState().clearCookies();
	}

	public HttpClient getHttpClient() {
		return httpClient;
	}

	public String getPassword() {
		return password;
	}

	private static final Logger logger = LoggerFactory.getLogger(Authentication.class);
}
