package com.xebialabs.deployit.client;

import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;

import java.util.Arrays;
import java.util.HashSet;

public class DeployitClient {

	private DeploymentListener listener;

    private Proxies proxies;

	public DeployitClient(DeploymentListener listener, Proxies proxies) {
		this.listener = listener;
        this.proxies = proxies;
	}

	public TaskState retrieveTaskInfo(final String taskId) {
		return proxies.getTaskService().getTask(taskId);
	}

	public void stopTask(String taskId) {
		proxies.getTaskService().stop(taskId);
	}

	public void startTask(String taskId) {
		proxies.getTaskService().start(taskId);
	}

	public void startTaskAndWait(final String taskId) {
		startTask(taskId);
		// Wait until done/failed
		boolean done = false;
		TaskState ti;
		while (!done) {

			ti = retrieveTaskInfo(taskId);
			TaskExecutionState state = ti.getState();
			listener.debug("Task state: " + state.toString());

			done = new HashSet<TaskExecutionState>(){{
				add(TaskExecutionState.DONE);
				add(TaskExecutionState.EXECUTED);
				add(TaskExecutionState.STOPPED);
				add(TaskExecutionState.CANCELLED);
			}}.contains(state);

			try {
				Thread.sleep(1000);
				listener.debug("Waiting for task to be done...");
			} catch (InterruptedException e) {
				Thread.currentThread().interrupt();
			}
		}
	}

	public void abortTask(String taskId) {
		proxies.getTaskService().abort(taskId);
	}

	public void cancelTask(String taskId) {
		proxies.getTaskService().cancel(taskId);
	}

	public void skipSteps(String taskId, Integer[] stepIds) {
		proxies.getTaskService().skip(taskId, Arrays.asList(stepIds));
	}


}
