package com.xebialabs.deployit.client;

import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;


class ImportHelper {

	private static final Logger logger = LoggerFactory.getLogger(ImportHelper.class);

    private Proxies proxies;

    ImportHelper(final Proxies proxies) {
        this.proxies = proxies;
    }

    /**
	 * Check whether the packageToImport parameter refers to a file by checking for its existence.
	 * If it is not a file, it should be a package in the importablePackages directory on the server, and should be
	 * importable from there.
	 */
	public ConfigurationItem doImport(String packageToImport) {
		try {
			URL url = new URL(packageToImport);
			if (url.getProtocol().equals("file")) {
				return processFilePath(url.getFile());
			} else {
				return proxies.getPackageService().fetch(packageToImport);
			}
		} catch (MalformedURLException e) {
			return processFilePath(packageToImport);
		}
	}

	private ConfigurationItem processFilePath(String path) {
		final File file = new File(path);
		if (file.exists()) {
			try {
				final FileUpload fileUpload = new FileUpload();
				fileUpload.setFileData(new FileInputStream(file));
				return proxies.getPackageService().upload(file.getName(), fileUpload);
			} catch (IOException e) {
				logger.error("The file \'{}\' exists, but could not be read for upload; perhaps it's not an archive.", file.toString());
				return null;
			}
		} else {
			if (!file.isAbsolute()) {
				return proxies.getPackageService().importPackage(path);
			} else {
				logger.error("The file \'{}\' does not exist at the given absolute path", file.toString());
				return null;
			}
		}
	}

}
