package com.xebialabs.deployit.documentation;

import java.io.File;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.util.OverthereFileCopier;

/**
 * Documentation uploader using Overthere. Meant to be used to copy generated HTML documentation to the
 * Deployit online docs website.
 * 
 * Parameters:
 * - hostname
 * - username
 * - password
 * - target path
 */
public class DocumentationUploader {

	public static void main(String[] args) {
		if (args.length < 5) {
			System.err.println("Usage: DocumentationUploader <hostname> <username> <password> <target directory> <source directory>");
			System.exit(1);
		}

		/*
		String hostName = "tech.xebialabs.com";
		String username = "tech";
		String password = "xebia@01";
		String path = "/home/tech/tmp/bla";
		String sourceDirectory = "build/doc";
		*/

		String hostName = args[0];
		String username = args[1];
		String password = args[2];
		String path = args[3];
		String sourceDirectory = args[4];

		OverthereConnection conn = Overthere.getConnection("ssh", getConnectionOptions(hostName, username, password));
		
		int result = 0;
		try {
			OverthereFile dst = conn.getFile(path);
			dst.mkdirs();
			OverthereFile src = LocalFile.valueOf(new File(sourceDirectory));
			OverthereFileCopier.copy(src, dst);
		} catch(Throwable t) {
			t.printStackTrace();
			result = 1;
		} finally {		
			conn.close();
		}

		System.exit(result);
	}

	private static ConnectionOptions getConnectionOptions(String address, String username, String password) {
		ConnectionOptions options = new ConnectionOptions();
		options.set("connectionType", SshConnectionType.SFTP);
		options.set("os", OperatingSystemFamily.UNIX);
		options.set("address", address);
		options.set("username", username);
		options.set("password", password);
		return options;
	}

}

