/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.util.OverthereFileCopier;
import java.io.File;

public class DocumentationUploader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: DocumentationUploader <hostname> <username> <password> <target directory> <source directory>");
            System.exit(1);
        }
        String hostName = args[0];
        String username = args[1];
        String password = args[2];
        String path = args[3];
        String sourceDirectory = args[4];
        OverthereConnection conn = Overthere.getConnection((String)"ssh", (ConnectionOptions)DocumentationUploader.getConnectionOptions(hostName, username, password));
        int result = 0;
        try {
            OverthereFile dst = conn.getFile(path);
            dst.mkdirs();
            OverthereFile src = LocalFile.valueOf((File)new File(sourceDirectory));
            OverthereFileCopier.copy((OverthereFile)src, (OverthereFile)dst);
        }
        catch (Throwable t) {
            t.printStackTrace();
            result = 1;
        }
        finally {
            conn.close();
        }
        System.exit(result);
    }

    private static ConnectionOptions getConnectionOptions(String address, String username, String password) {
        ConnectionOptions options = new ConnectionOptions();
        options.set("connectionType", (Object)SshConnectionType.SFTP);
        options.set("os", (Object)OperatingSystemFamily.UNIX);
        options.set("address", (Object)address);
        options.set("username", (Object)username);
        options.set("password", (Object)password);
        return options;
    }
}

