/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Information about a block.
 * <p>
 * A block is a representation for a sequence of steps. It is used to facilitate the parallel execution of steps, and
 * also for for sequential orchestration.
 */
@PublicApiRef
public interface BlockState {

    /**
     * Returns id of the block.
     *
     * @return the id
     */
    String getId();

    /**
     * Returns description of the block.
     */
    String getDescription();

    /**
     * @return the execution state of the block.
     */
    BlockExecutionState getState();

    /**
     * @return true if block contains steps
     */
    Boolean hasSteps();

    /**
     * @return state of the satellite
     */
    SatelliteConnectionState getSatelliteConnectionState();
}
