/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Information about a step block.
 *
 * A block is a representation for a sequence of steps and is used to facilitate the parallel execution of steps.
 */
@PublicApiRef
public interface StepBlockState extends BlockState {

    /**
     * Returns number of step which is being executed.
     */
    int getCurrentStep();

    /**
     * Returns states of all the states included in this block.
     */
    List<StepState> getSteps();

    /**
     * Returns satellite if it used in current block
     */
    String getSatelliteId();

    @Override
    default Boolean hasSteps() {
        return !getSteps().isEmpty();
    }
}
