/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import java.util.stream.StreamSupport;

public interface PhaseContainerState extends BlockState {

    Iterable<PhaseState> getBlocks();

    @Override
    default Boolean hasSteps() {
        return StreamSupport.stream(getBlocks().spliterator(), false).anyMatch(PhaseState::hasSteps);
    }
}
