/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto

import org.joda.time.DateTime


case class ApplicationDeploymentPackage(applicationName: String, versionTag: VersionTag)

case class ApplicationDeploymentPackageState(applicationName: String, applicationPath: String, state: DeploymentPackageState)

case class DeploymentPackageState(destination: String,
                                  namespace: String,
                                  versionTag: VersionTag,
                                  deploymentStatus: String,
                                  deploymentType: String,
                                  user: String,
                                  lastChangeTime: DateTime)

case class VersionTag(label: String, state: String)

case class DeployedApplicationPackage(applicationName: String, applicationPath: String, versionTag: VersionTag, destination: String, namespace: String)
