/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

import java.util.Iterator;
import java.util.List;

@SuppressWarnings("serial")
@Metadata(virtual = true)
/**
 * @deprecated Replaced by the {@link com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem.get$validationMessages()}
 */
@Deprecated
public class ValidatedConfigurationItem implements ConfigurationItem {

    private ConfigurationItem wrapped;

    public ValidatedConfigurationItem(ConfigurationItem wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public String getId() {
        return wrapped.getId();
    }

    @Override
    public void setId(String id) {
        wrapped.setId(id);
    }

    @Override
    public String getName() {
        return wrapped.getName();
    }

    @Override
    public Type getType() {
        return wrapped.getType();
    }

    @Override
    public <T> T getProperty(String key) {
        return wrapped.getProperty(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return wrapped.hasProperty(key);
    }

    @Override
    public <T> void setProperty(String key, T value) {
        wrapped.setProperty(key, value);
    }

    @Override
    public List<ValidationMessage> get$validationMessages() {
        return wrapped.get$validationMessages();
    }

    @Override
    public Integer get$internalId() {
        return wrapped.get$internalId();
    }

    @Override
    public Integer get$securedCi() {
        return wrapped.get$securedCi();
    }

    @Override
    public String get$directoryReference() {
        return wrapped.get$directoryReference();
    }

    @Override
    public String get$securedDirectoryReference() {
        return wrapped.get$securedDirectoryReference();
    }

    @Override
    public String get$referenceId() { return wrapped.get$referenceId(); }

    public List<ValidationMessage> getValidations() {
        return wrapped.get$validationMessages();
    }

    public void setValidations(List<ValidationMessage> validations) {
        List<ValidationMessage> $validationMessages = wrapped.get$validationMessages();
        $validationMessages.clear();
        $validationMessages.addAll(validations);
    }

    public ConfigurationItem getWrapped() {
        return wrapped;
    }

    @Override
    public String toString() {
        List<ValidationMessage> validations = wrapped.get$validationMessages();
        StringBuilder msg = new StringBuilder(String.format("CI [%s]: %d validation messages", wrapped.getId(), validations.size()));

        if (validations.isEmpty()) {
            return msg.toString();
        }
        msg.append(": ");
        Iterator<ValidationMessage> iterator = validations.iterator();
        msg.append(iterator.next());
        while (iterator.hasNext()) {
            msg.append(", ").append(iterator.next());
        }
        return msg.toString();
    }
}
