/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Contains information about a server instance.
 */
@XmlRootElement(name = "server-info")
@PublicApiRef
public class ServerInfo extends AbstractDto {

    private String version;

    private String serverUrl;

    private List<ServerPluginInfo> pluginsInfo = new ArrayList<>();

    private String databaseInfo;

    @XmlElementWrapper(name = "plugins")
    @XmlElement(name = "plugin-info")
    public List<ServerPluginInfo> getPluginsInfo() {
        return pluginsInfo;
    }

    /**
     * @param pluginsInfo All the installed plugins as a list of {@link ServerPluginInfo}.
     */
    public void setPluginsInfo(List<ServerPluginInfo> pluginsInfo) {
        this.pluginsInfo = pluginsInfo;
    }

    /**
     * @return The server version.
     */
    @XmlElement(name = "version")
    public String getVersion() {
        return version;
    }

    /**
     * @param version The server version.
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * @return The server url.
     */
    @XmlElement(name = "server-url")
    public String getServerUrl() {
        return serverUrl;
    }

    /**
     * @param serverUrl The server url.
     */
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    /**
     * @return The databaseName  and version.
     */
    @XmlElement(name = "database")
    public String getDatabaseInfo() {
        return databaseInfo;
    }

    /**
     * @param databaseInfo The databaseName and version.
     */
    public void setDatabaseInfo(String databaseInfo) {
        this.databaseInfo = databaseInfo;
    }

}
