/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.security;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


@XmlRootElement
public class RolePrincipals extends AbstractDto {

    private Role role;

    private List<String> principals = new ArrayList<>();

    public RolePrincipals() {
    }

    public RolePrincipals(Role role, List<String> principals) {
        this.role = role;
        this.principals = new ArrayList<>(principals);
    }

    @XmlElement
    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @XmlElement
    public List<String> getPrincipals() {
        deduplicate();
        return principals;
    }

    public void setPrincipals(List<String> principals) {
        this.principals = principals;
        deduplicate();
    }

    public void addPrincipals(List<String> principals) {
        this.principals.addAll(principals);
        deduplicate();
    }

    private void deduplicate() {
        Set<String> principalSet = new LinkedHashSet<>(principals);
        principals.clear();
        principals.addAll(principalSet);
    }
}
