/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api.xml;

import jakarta.ws.rs.core.MediaType;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jboss.resteasy.annotations.Decorator;
import org.jboss.resteasy.spi.DecoratorProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Decorator(processor=Processor.class, target=Marshaller.class)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
@Inherited
public @interface OmitXmlPreamble {

    public static class Processor
    implements DecoratorProcessor<Marshaller, OmitXmlPreamble> {
        private static final Logger logger = LoggerFactory.getLogger(Processor.class);

        public Marshaller decorate(Marshaller target, OmitXmlPreamble annotation, Class type, Annotation[] annotations, MediaType mediaType) {
            try {
                target.setProperty("jaxb.fragment", (Object)true);
                logger.trace("Omitting XML Preamble");
                return target;
            }
            catch (PropertyException ignored) {
                return target;
            }
        }
    }
}

