/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api;

import java.lang.annotation.*;

/**
 * Indicates how deep should CI deserializer go while resolving ci references
 * You should use it if you'd like to optimize your APIs as it allows to reduce the amount of data being extracted
 * from the database.
 */
@Target({ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface LimitCiTreeDepth {

    /**
     * Depth of CI tree to be read during dependencies resolution process
     * <p>Defaults to "almost" unlimited.
     */
    int value() default Integer.MAX_VALUE;
}
