/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.dto.QueuedTask;
import com.xebialabs.deployit.engine.api.dto.TaskQueueSummary;
import com.xebialabs.xlplatform.documentation.PublicApi;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import java.util.List;

/**
 * Provides insights into Deploy's task queue: queued tasks, queue summary.
 */
@Path("/queue")
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@PublicApi
public interface QueueService {

    /**
     * Lists all the {@link QueuedTask QueuedTasks} waiting in the task queue.
     *
     * @return A List of {@link QueuedTask QueuedTasks}
     */
    @GET
    @Path("tasks")
    List<QueuedTask> queuedTasks();

    /**
     * Aggregate summary of the tasks currently running and waiting in the queue.
     *
     * @return A {@link QueuedTask TaskQueueSummary}
     */
    @GET
    @Path("summary")
    TaskQueueSummary taskQueueSummary();
}
