/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlRootElement;

import java.io.Serializable;
import java.util.Objects;
import java.util.List;

@XmlRootElement(name = "CIPermissions")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CIPermissionDto extends AbstractDto implements Serializable {

    @JsonProperty("inheritParentPermission")
    private boolean inheritParentPermission;
    @JsonProperty("rolePermissions")
    private List<EditRolePermissionsDto> editRolePermissionsDtoList;

    public boolean isInheritParentPermission() {
        return inheritParentPermission;
    }
    public void setInheritParentPermission(boolean inheritParentPermission) {
        this.inheritParentPermission = inheritParentPermission;
    }

    public List<EditRolePermissionsDto> getEditRolePermissionsDtoList() {
        return editRolePermissionsDtoList;
    }


    public void setEditRolePermissionsDtoList(List<EditRolePermissionsDto> editRolePermissionsDtoList) {
        this.editRolePermissionsDtoList = editRolePermissionsDtoList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CIPermissionDto that = (CIPermissionDto) o;
        return inheritParentPermission == that.inheritParentPermission;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(inheritParentPermission);
    }
}
