/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import org.joda.time.DateTime;

public class DeploymentTaskReportLine {
    private String taskId;
    private DateTime startDate;
    private DateTime completionDate;
    private String status;
    private String taskType;
    private String user;
    private String environment;
    private String environmentId;
    private String environmentIdWithoutRoot;
    private String deploymentPackage;
    private Boolean rolledBack;
    private BlockState block;
    private String workerName;
    private String originalTaskType;

    public DeploymentTaskReportLine() {
    }

    /**
     * @return The Taks ID.
     */
    public String getTaskId() {
        return taskId;
    }

    /**
     * @param taskId The Taks ID.
     * @return The this object.
     */
    public DeploymentTaskReportLine setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    /**
     * @return The Start Date of Task.
     */
    public DateTime getStartDate() {
        return startDate;
    }

    /**
     * @param startDate The Start Date of Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * @return The Completion Date of Task.
     */
    public DateTime getCompletionDate() {
        return completionDate;
    }

    /**
     * @param completionDate The Completion Date of Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    /**
     * @return The Status of Task.
     */
    public String getStatus() {
        return status;
    }

    /**
     * @param status The Status of Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * re
     *
     * @return The Task Type.
     */
    public String getTaskType() {
        return taskType;
    }

    /**
     * @param taskType The Task Type.
     * @return The this object.
     */
    public DeploymentTaskReportLine setTaskType(String taskType) {
        this.taskType = taskType;
        return this;
    }

    /**
     * @return The user associated with the Task.
     */
    public String getUser() {
        return user;
    }

    /**
     * @param user The user associated with the Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setUser(String user) {
        this.user = user;
        return this;
    }

    /**
     * @return The Environment CI path associated with the Task.
     */
    public String getEnvironment() {
        return environment;
    }

    /**
     * @param environment The Environment CI path associated with the Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    /**
     * @return The Environment CI ID associated with the Task.
     */
    public String getEnvironmentId() {
        return environmentId;
    }

    /**
     * @param environmentId The Environment CI ID associated with the Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    /**
     * @return The Environment CI name associated with the Task.
     */
    public String getEnvironmentIdWithoutRoot() {
        return environmentIdWithoutRoot;
    }

    /**
     * @param environmentIdWithoutRoot The Environment CI name associated with the Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setEnvironmentIdWithoutRoot(String environmentIdWithoutRoot) {
        this.environmentIdWithoutRoot = environmentIdWithoutRoot;
        return this;
    }

    /**
     * @return The Deployment Package associated with the Task.
     */
    public String getDeploymentPackage() {
        return deploymentPackage;
    }

    /**
     * @param deploymentPackage The Deployment Package associated with the Task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
        return this;
    }

    /**
     * @return The flag marking if this Task is Rollback of an original task (rollback task shares same Task ID as original task).
     */
    public Boolean getRolledBack() {
        return rolledBack;
    }

    /**
     * @param rolledBack The flag marking if this Task is Rollback of an original task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setRolledBack(Boolean rolledBack) {
        this.rolledBack = rolledBack;
        return this;
    }

    /**
     * @return If FULL FetchMode was toggled block field will contain details of task execution blocks.
     */
    public BlockState getBlock() {
        return block;
    }

    /**
     * @param block The Task execution blocks.
     * @return The this object.
     */
    public DeploymentTaskReportLine setBlock(BlockState block) {
        this.block = block;
        return this;
    }

    /**
     * @return The name of worker that executes this task.
     */
    public String getWorkerName() {
        return workerName;
    }

    /**
     * @param workerName The name of worker that executes this task.
     * @return The this object.
     */
    public DeploymentTaskReportLine setWorkerName(String workerName) {
        this.workerName = workerName;
        return this;
    }

    /**
     * @return The original task type mapped in db
     */
    public String getOriginalTaskType() {
        return originalTaskType;
    }

    /**
     * @param originalTaskType original task type mapped in db
     * @return The this object.
     */
    public DeploymentTaskReportLine setOriginalTaskType(String originalTaskType) {
        this.originalTaskType = originalTaskType;
        return this;
    }
}
