/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

/**
 * Result of XL Deploy as Code YAML processing operations.
 */
@PublicApiRef
@XmlRootElement(name = "xld-as-code-result")
public class XLDAsCodeResult implements Serializable {

    private boolean success;
    private String message;
    private String content;
    private String error;

    /**
     * Default constructor for deserialization.
     */
    public XLDAsCodeResult() {
    }

    /**
     * Constructor for creating XLDAsCodeResult.
     *
     * @param success Whether the operation was successful
     * @param message Descriptive message about the operation result
     * @param content Generated YAML content (for generate operations)
     * @param error Error details if the operation failed
     */
    @JsonCreator
    public XLDAsCodeResult(
            @JsonProperty("success") boolean success,
            @JsonProperty("message") String message,
            @JsonProperty("content") String content,
            @JsonProperty("error") String error) {
        this.success = success;
        this.message = message;
        this.content = content;
        this.error = error;
    }

    /**
     * @return Whether the operation was successful
     */
    @XmlElement(name = "success")
    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    /**
     * @return Descriptive message about the operation result
     */
    @XmlElement(name = "message")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * @return Generated YAML content (for generate operations)
     */
    @XmlElement(name = "content")
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * @return Error details if the operation failed
     */
    @XmlElement(name = "error")
    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }
}
