/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Contains information about a server instance.
 */
@XmlRootElement(name = "server-info")
@PublicApiRef
public class ServerInfo extends AbstractDto {

    private String version;

    private List<ServerPluginInfo> pluginsInfo = new ArrayList<>();

    private List<String> classpathEntries = new ArrayList<>();

    /**
     * @return All the installed plugins as a list of {@link ServerPluginInfo}.
     */
    @XmlElementWrapper(name = "plugins")
    @XmlElement(name = "plugin-info")
    public List<ServerPluginInfo> getPluginsInfo() {
        return pluginsInfo;
    }

    /**
     * @param pluginsInfo All the installed plugins as a list of {@link ServerPluginInfo}.
     */
    public void setPluginsInfo(List<ServerPluginInfo> pluginsInfo) {
        this.pluginsInfo = pluginsInfo;
    }

    /**
     * @return The server version.
     */
    @XmlElement(name = "version")
    public String getVersion() {
        return version;
    }

    /**
     * @param version The server version.
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * @return The list of entries in the Java classpath.
     */
    @XmlElementWrapper(name = "classpath")
    @XmlElement(name = "classpath-entry")
    public List<String> getClasspathEntries() {
        return classpathEntries;
    }

    /**
     * @param classpathEntries The list of entries in the Java classpath.
     */
    public void setClasspathEntries(List<String> classpathEntries) {
        this.classpathEntries = classpathEntries;
    }



}
