/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;


public class TaskCreatedEvent extends TaskBaseEvent {

    private final String taskDescription;
    private final String ciId;
    
    public TaskCreatedEvent(String taskId, String taskDescription, String id) {
        super(taskId, String.format("Created task %s %s for CI %s", format(taskId), format(taskDescription), 
            format(id)));
        this.taskDescription = taskDescription;
        this.ciId = id;
    }

    public String getTaskDescription() {
        return taskDescription;
    }

    public String getCiId() {
        return ciId;
    }
    
}
