/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;

import java.util.List;

public class RolePermissionsChangedEvent extends AuditableDeployitEvent {

    private final List<String> newPermissions;
    private final String ciId;

    public RolePermissionsChangedEvent(String ciId, List<String> newPermissions) {
        super("security", String.format("Updated role permissions on %s:\n", format(ciId)) + join(newPermissions));
        this.ciId = ciId;
        this.newPermissions = newPermissions;
    }

    public List<String> getNewPermissions() {
        return newPermissions;
    }

    public String getCiId() {
        return ciId;
    }

}
