/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.execution;

import java.io.Serializable;

/**
 * Interface that can be implemented by objects stored as step execution context attributes to get notified about the
 * lifecycle of the task or step execution context.
 *
 * @since 3.8.0
 */
public interface ExecutionStateListener extends Serializable {
    void stepStateChanged(StepExecutionStateEvent event);

    void taskStateChanged(TaskExecutionStateEvent event);
}
