/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class CiMovedEvent extends CiBaseEvent {

    private ConfigurationItem entity;
    private String newId;
    
    public CiMovedEvent(ConfigurationItem ci, String newId) {
        super("repository", String.format("Moved CI %s to %s", format(ci), format(newId)));
        this.entity = ci;
        this.newId = newId;
    }

    public String getEntity() {
        return entity.getId();
    }

    public String getNewId() {
        return newId;
    }

}
