/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;

import java.util.Arrays;
import java.util.List;

public class CisCreatedEvent extends CiBaseEvent {
    public CisCreatedEvent(SCMTraceabilityData traceabilityData, ConfigurationItem... cis) {
        super("repository", String.format("Created CIs %s", format(cis)), Arrays.asList(cis), traceabilityData);
    }

    public CisCreatedEvent(SCMTraceabilityData traceabilityData, List<ConfigurationItem> cis) {
        super("repository", String.format("Created CIs %s", format(cis)), cis, traceabilityData);
    }
}
