/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.upgrade;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    public static final String VERSION_0 = "0.0.0";
    public static final List<String> RELEASE_CANDIDATE_CLASSIFIERS = Collections.unmodifiableList(Arrays.asList("alpha", "beta", "rc"));
    private String component;
    private int major;
    private int minor;
    private int micro;
    private String classifier = "";
    private int dataModel;

    public static Version valueOf(String component, String versionString) {
        Matcher matcher = Pattern.compile("([0-9]+)\\.([0-9]+)\\.?([0-9]+)?-?([^#]*)(#([0-9]+))?$").matcher(versionString);
        if (!matcher.matches()) {
            throw new RuntimeException("Unsupported version number format " + versionString);
        }
        Version version = new Version();
        version.component = component;
        version.major = Integer.parseInt(matcher.group(1));
        version.minor = Integer.parseInt(matcher.group(2));
        if (matcher.group(3) != null) {
            version.micro = Integer.parseInt(matcher.group(3));
        }
        if (matcher.group(4) != null) {
            version.classifier = matcher.group(4);
        }
        if (matcher.group(5) != null) {
            version.dataModel = Integer.parseInt(matcher.group(6));
        }
        return version;
    }

    public String getComponent() {
        return this.component;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public int getDataModel() {
        return this.dataModel;
    }

    public String getVersion() {
        StringBuilder builder = new StringBuilder(String.format("%d.%d.%d", this.major, this.minor, this.micro));
        if (!this.classifier.isEmpty()) {
            builder.append(String.format("-%s", this.classifier));
        }
        if (this.dataModel != 0) {
            builder.append(String.format("#%d", this.dataModel));
        }
        return builder.toString();
    }

    public String toString() {
        return String.format("%s %s", this.component, this.getVersion());
    }

    @Override
    public int compareTo(Version o) {
        if (!this.component.equals(o.component)) {
            throw new IllegalArgumentException("Cannot compare versions for 2 components: " + this.toString() + " and " + o.toString());
        }
        if (this.major != o.major) {
            return this.major - o.major;
        }
        if (this.minor != o.minor) {
            return this.minor - o.minor;
        }
        if (this.micro != o.micro) {
            return this.micro - o.micro;
        }
        if (this.dataModel != o.dataModel) {
            return this.dataModel - o.dataModel;
        }
        if (this.isReleaseCandidateClassifier(this.classifier) && !this.isReleaseCandidateClassifier(o.classifier)) {
            return -1;
        }
        if (!this.isReleaseCandidateClassifier(this.classifier) && this.isReleaseCandidateClassifier(o.classifier)) {
            return 1;
        }
        return this.classifier.compareTo(o.classifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.micro == version.micro && this.minor == version.minor && this.classifier.equals(version.classifier) && this.component.equals(version.component) && this.dataModel == version.dataModel;
    }

    public int hashCode() {
        int result = this.component.hashCode();
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.classifier.hashCode();
        result = 31 * result + this.dataModel;
        return result;
    }

    public boolean isVersion0() {
        return this.equals(Version.valueOf(this.component, VERSION_0));
    }

    private boolean isReleaseCandidateClassifier(String classifier) {
        for (String releaseCandidateClassifier : RELEASE_CANDIDATE_CLASSIFIERS) {
            if (!classifier.startsWith(releaseCandidateClassifier)) continue;
            return true;
        }
        return false;
    }
}

