/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class CiCopiedEvent extends CiBaseEvent {

    private ConfigurationItem entity;
    private String newId;
    
    public CiCopiedEvent(ConfigurationItem ci, String newId) {
        super("repository", String.format("Copied CI %s to new id %s", format(ci), format(newId)));
        this.entity = ci;
        this.newId = newId;
    }

    public ConfigurationItem getCi() {
        return entity;
    }

    public String getEntity() {
        return entity.getId();
    }

    public String getNewId() {
        return newId;
    }

}
