/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.execution;

import com.xebialabs.deployit.engine.api.execution.*;

public interface TaskExecutionStateEvent {

    /**
     * Returns the previous state of the task.
     */
    TaskExecutionState previousState();

    /**
     * Returns the current state of the task.
     */
    TaskExecutionState currentState();

    /**
     * Return the detailed task information object.
     */
    @SuppressWarnings("deprecation")
    TaskWithSteps task();
}
