/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.orchestration;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;

import java.util.List;

public final class Orchestrations {

    public static InterleavedOrchestration interleaved(String description, List<Delta> operations) {
        return new InterleavedOrchestration(description, operations);
    }

    public static InterleavedOrchestration interleaved(String description, Delta... operations) {
        return new InterleavedOrchestration(description, operations);
    }

    public static ParallelOrchestration parallel(String description, Orchestration... orchestrations) {
        return new ParallelOrchestration(description, orchestrations);
    }

    public static ParallelOrchestration parallel(String description, List<Orchestration> orchestrations) {
        return new ParallelOrchestration(description, orchestrations);
    }

    public static SerialOrchestration serial(String description, Orchestration... orchestrations) {
        return new SerialOrchestration(description, orchestrations);
    }

    public static SerialOrchestration serial(String description, List<Orchestration> orchestrations) {
        return new SerialOrchestration(description, orchestrations);
    }

}
