/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.spi.event;

import com.xebialabs.deployit.engine.spi.event.AuditableDeployitEvent;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import java.util.ArrayList;
import java.util.List;

public abstract class CiBaseEvent
extends AuditableDeployitEvent {
    private SCMTraceabilityData scmTraceabilityData;
    private List<ConfigurationItem> cis = new ArrayList<ConfigurationItem>();

    public CiBaseEvent(String component, String message) {
        super(component, message);
    }

    public CiBaseEvent(String component, String message, List<ConfigurationItem> cis, SCMTraceabilityData scmTraceabilityData) {
        super(component, message);
        this.cis = cis;
        this.scmTraceabilityData = scmTraceabilityData;
    }

    public CiBaseEvent(String component, String message, List<ConfigurationItem> cis) {
        this(component, message, cis, null);
    }

    protected static String format(ConfigurationItem ... cis) {
        StringBuilder sb = new StringBuilder();
        for (ConfigurationItem ci : cis) {
            sb.append(CiBaseEvent.format(ci));
            sb.append(" ");
        }
        return sb.toString();
    }

    protected static String format(List<ConfigurationItem> ciList) {
        StringBuilder sb = new StringBuilder();
        for (ConfigurationItem configurationItem : ciList) {
            sb.append(CiBaseEvent.format(configurationItem));
            sb.append(" ");
        }
        return sb.toString();
    }

    protected static String format(ConfigurationItem configurationItem) {
        StringBuilder sb = new StringBuilder();
        sb.append(configurationItem.getType());
        sb.append("[");
        sb.append(configurationItem.getId());
        sb.append("]");
        return sb.toString();
    }

    public List<ConfigurationItem> getCis() {
        return this.cis;
    }

    public SCMTraceabilityData getSCMTraceabilityData() {
        return this.scmTraceabilityData;
    }
}

