/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.orchestration;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;

import java.util.Arrays;
import java.util.List;

import static java.util.Collections.unmodifiableList;

/**
 * The lowest type of sub-plan, this plan contains steps which can be executed and {@link com.xebialabs.deployit.plugin.api.deployment.specification.Delta} objects
 * for which this InterleavedPlan has been built.
 *
 * The steps in the InterleavedPlan are sorted.
 */
public final class InterleavedOrchestration implements Orchestration {
    private List<Delta> deltas;
    private String description = "";

    InterleavedOrchestration(String description, List<Delta> deltas) {
        this.deltas = unmodifiableList(deltas);
        this.description = description;
    }

    InterleavedOrchestration(String description, Delta... deltas) {
        this(description, Arrays.asList(deltas));
    }

    /**
     * Gets the {@link com.xebialabs.deployit.plugin.api.deployment.specification.Delta}s for which this InterleavedPlan has been compiled
     * @return the Delta's
     */
    public List<Delta> getDeltas() {
        return deltas;
    }

    @Override
    public String getType() {
        return InterleavedOrchestration.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}
