/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;

import java.util.List;

public class RolePrincipalsChangedEvent extends AuditableDeployitEvent {

    private final List<String> newPrincipals;

    public RolePrincipalsChangedEvent(List<String> newPrincipals) {
        super("security", String.format("Updated role principals:\n") + join(newPrincipals));
        this.newPrincipals = newPrincipals;
    }

    public List<String> getNewPrincipals() {
        return newPrincipals;
    }

}
