package com.xebialabs.deployit.engine.spi.orchestration;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;

import java.util.List;

public final class Orchestrations {

    public static InterleavedOrchestration interleaved(List<Delta> operations) {
        return new InterleavedOrchestration(operations);
    }

    public static InterleavedOrchestration interleaved(Delta... operations) {
        return new InterleavedOrchestration(operations);
    }

    public static ParallelOrchestration parallel(Orchestration... orchestrations) {
        return new ParallelOrchestration(orchestrations);
    }

    public static ParallelOrchestration parallel(List<Orchestration> orchestrations) {
        return new ParallelOrchestration(orchestrations);
    }

    public static SerialOrchestration serial(Orchestration... orchestrations) {
        return new SerialOrchestration(orchestrations);
    }

    public static SerialOrchestration serial(List<Orchestration> orchestrations) {
        return new SerialOrchestration(orchestrations);
    }
}
