package com.xebialabs.deployit.server.api.importer;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.plugin.api.udm.Metadata;

import static com.google.common.base.Strings.emptyToNull;

/**
 */
public class PackageInfo {
    ImportSource source;

    String applicationName;

    String directories;

    String applicationVersion;

    public PackageInfo(ImportSource source) {
        this.source = source;
    }

    public ImportSource getSource() {
        return source;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public String getDirectories() {
        return directories;
    }

    public String getApplicationId() {
        return Joiner.on("/").skipNulls().join(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName(), emptyToNull(directories), applicationName);
    }

    public String getApplicationVersion() {
        return applicationVersion;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setDirectories(String directories) {
        String dir = directories;
        if (dir.startsWith("/")) {
            dir = dir.substring(1);
        }
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        this.directories = dir;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }
}
