package com.xebialabs.deployit.engine.spi.orchestration;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

/**
 * A CompositePlan holds other sub-plans which are either parallellized (see: {@link ParallelOrchestration}) or serialized (see: {@link SerialOrchestration}).
 */
public abstract class CompositeOrchestration implements Orchestration {
    protected List<Orchestration> plans;

    protected CompositeOrchestration(Orchestration... plans) {
        this.plans = newArrayList(plans);
    }

    protected CompositeOrchestration(List<Orchestration> plans) {
        this.plans = newArrayList(plans);
    }

    /**
     * Gets the full list of plans.
     * @return the full list of plans.
     */
    public List<Orchestration> getPlans() {
        return plans;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }
}
