package com.xebialabs.deployit.engine.spi.orchestration;

import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * An Orchestrator converts a DeltaSpecification into a Orchestration, which can then be resolved to result in steps.
 * Using the {@link com.xebialabs.deployit.engine.spi.orchestration.Orchestrations} utilities, it is easy to assimilate the Orchestration.
 */
public interface Orchestrator {

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.TYPE)
    public @interface Metadata {
        public String name();
        public String description() default "";
    }
    
    Orchestration orchestrate(DeltaSpecification specification);
}
