package com.xebialabs.deployit.server.api.importer;

import static com.google.common.base.Preconditions.checkState;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newHashSet;
import static com.xebialabs.deployit.server.api.util.IdGenerator.generateId;

import java.util.List;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;

public final class ImportedPackage {

    private Application application;

    private Version version;

    private final PackageInfo packageInfo;

    public ImportedPackage(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
        createApplicationEntity(packageInfo);
        createDeploymentPackageEntity(packageInfo);
    }

    public ImportedPackage(PackageInfo packageInfo, Application application, Version version) {
        this.packageInfo = packageInfo;
        this.application = application;
        this.version = version;
    }

    public PackageInfo getPackageInfo() {
        return packageInfo;
    }

    public Application getApplication() {
        return application;
    }

    public Version getVersion() {
        return version;
    }

    @Deprecated
    public DeploymentPackage getDeploymentPackage() {
        return (DeploymentPackage) version;
    }

    public List<Deployable> getDeployables() {
        return newArrayList(version.getDeployables());
    }

    public void setDeployables(List<Deployable> deployables) {
        checkState(version instanceof DeploymentPackage, "Cannot set deployables on a non udm.DeploymentPackage (%s)", version.getType());
        ((DeploymentPackage) version).setDeployables(newHashSet(deployables));
    }

    public void addDeployable(Deployable deployable) {
        checkState(version instanceof DeploymentPackage, "Cannot add deployables on a non udm.DeploymentPackage (%s)", version.getType());
        ((DeploymentPackage) version).addDeployable(deployable);
    }

    private void createApplicationEntity(PackageInfo packageInfo) {
        application = Type.valueOf(Application.class).getDescriptor().newInstance();
        application.setId(packageInfo.getApplicationId());
    }

    private void createDeploymentPackageEntity(PackageInfo packageInfo) {
        version = Type.valueOf(DeploymentPackage.class).getDescriptor().newInstance();
        version.setId(generateId(application, packageInfo.applicationVersion));
        version.setApplication(application);
    }
}
