/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.pegdown.PegDownProcessor;

public class MarkdownHtmlGenerator {
    private final File markdownFile;
    private final ContextProperties contextProperties;
    private final PegDownProcessor markdownProcessor = new PegDownProcessor();

    public MarkdownHtmlGenerator(File markdownFile, ContextProperties contextProperties) {
        this.markdownFile = markdownFile;
        this.contextProperties = contextProperties;
    }

    public void generate(Writer writer) {
        try {
            String markdownText = IOUtils.getText(this.markdownFile);
            markdownText = IOUtils.replacePlaceholders(markdownText, this.contextProperties);
            String html = this.markdownProcessor.markdownToHtml(markdownText);
            writer.write(html);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

