package com.xebialabs.deployit.documentation;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.pegdown.PegDownProcessor;

import static com.xebialabs.deployit.documentation.IOUtils.getText;
import static com.xebialabs.deployit.documentation.IOUtils.replacePlaceholders;

public class MarkdownHtmlGenerator {

    private final File markdownFile;
    private final ContextProperties contextProperties;
    private final PegDownProcessor markdownProcessor = new PegDownProcessor();

    public MarkdownHtmlGenerator(final File markdownFile, ContextProperties contextProperties) {
        this.markdownFile = markdownFile;
        this.contextProperties = contextProperties;
    }

    public void generate(final Writer writer) {
        try {
            String markdownText = getText(markdownFile);
            markdownText = replacePlaceholders(markdownText, contextProperties);
            String html = markdownProcessor.markdownToHtml(markdownText);
            writer.write(html);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
