package com.xebialabs.deployit.documentation;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

public class StepReferenceFreemarkerTemplate {

    private Template template;

    private final Writer writer;

    public StepReferenceFreemarkerTemplate(final Writer writer) throws IOException {
        final Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(getClass(), "/ftl");
        this.template = configuration.getTemplate("steps.ftl");
        this.writer = writer;
    }

    public void writeGeneratedPage(HashMap<String, Object> templateData) throws IOException, TemplateException {
        template.process(templateData, writer);
    }
}
