/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.collect.Sets;
import com.xebialabs.commons.html.Element;
import com.xebialabs.commons.html.HtmlWriter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CiReferenceHtmlWriter
extends HtmlWriter {
    private Set<Type> typesInDocument = Sets.newHashSet();

    public CiReferenceHtmlWriter(PrintWriter writer) {
        super(writer);
    }

    public void startCiReference() {
        this.div(new Object[0]).cssClass("ci-reference").writeOpen();
    }

    public void endCiReference() {
        this.div(new Object[0]).writeClose();
    }

    public void tocHeader() {
        this.h1(new Object[]{"CI Reference"}).cssClass("ci-toc-category").write();
        this.h2(new Object[]{"Configuration Item Overview"}).write();
    }

    public void startToc() {
        this.table(new Object[0]).cssClass("ci-toc").writeOpen();
        this.rowHeader(new Object[]{"CI", "Description"}).cssClass("odd ci-toc-header").write();
    }

    public void endToc() {
        this.table(new Object[0]).writeClose();
    }

    public void tocEntry(Descriptor ci, String firstSentence, int row) {
        Element type = this.link("#" + ci.getType(), new Object[]{ci.getType()});
        if (ci.isVirtual()) {
            type = type.cssClass("virtual-type");
        }
        this.row(new Object[]{type, firstSentence}).cssClass(row % 2 == 0 ? "even" : "odd").write();
    }

    public void detailsHeader() {
        this.h2(new Object[]{"Configuration Item Details"}).cssClass("ci-details-title").write();
    }

    public void detailsSeparator() {
        this.hr().write();
    }

    public void ciDescription(String description) {
        this.p(new Object[]{description}).cssClass("ci-description").write();
    }

    public void ciDetailTitle(Type type) {
        this.anchor(type.toString(), new Object[0]).write();
        this.h3(new Object[]{type}).cssClass("ci-detail-title").write();
    }

    public void ciTypeInfo(Descriptor ci) {
        if (ci.getSuperClasses().isEmpty()) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("ci-relations-table");
        if (ci.isVirtual()) {
            table.add(new Object[]{this.tr(new Object[]{this.th(new Object[]{"Virtual Type"}).attribute("colspan", "2")})});
        }
        if (!ci.getSuperClasses().isEmpty()) {
            table.add(new Object[]{this.generateTypeRow(ci.getSuperClasses(), "Type&nbsp;Hierarchy", " >> ")});
        }
        if (!ci.getInterfaces().isEmpty()) {
            table.add(new Object[]{this.generateTypeRow(ci.getInterfaces(), "Interfaces", ", ")});
        }
        table.write();
    }

    private Element generateTypeRow(Collection<Type> types, String header, String separator) {
        Element row = this.rowHeader(new Object[]{header});
        Element cell = this.td(new Object[0]);
        row.add(new Object[]{cell});
        int i = 0;
        for (Type type : types) {
            cell.add(new Object[]{this.render(type)});
            if (++i >= types.size()) continue;
            cell.add(new Object[]{separator});
        }
        return row;
    }

    private String render(Type type) {
        if (this.typesInDocument.contains(type)) {
            return this.link("#" + type.toString(), new Object[]{type}).toString();
        }
        return type.toString();
    }

    public void ciProperties(Collection<PropertyDescriptor> properties, String category) {
        if (properties.isEmpty()) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("ci-table");
        table.add(new Object[]{this.rowHeader(new Object[]{"", "", category}).cssClass("odd ci-prop-header")});
        int row = 0;
        for (PropertyDescriptor property : properties) {
            String css = row % 2 == 0 ? "even" : "odd";
            table.add(new Object[]{this.getPropertyInfoRow(property).cssClass(css)});
            table.add(new Object[]{this.getPropertyDescriptionRow(property).cssClass(css)});
            ++row;
        }
        table.write();
    }

    private Element getPropertyInfoRow(PropertyDescriptor descriptor) {
        Element row = this.tr(new Object[0]);
        row.add(new Object[]{this.td(new Object[]{this.getInspectionIcon(descriptor)}).cssClass("icon-cell")});
        row.add(new Object[]{this.td(new Object[]{this.getRequiredIcon(descriptor)}).cssClass("icon-cell")});
        Element cell = this.div(new Object[0]).cssClass("ci-property-info");
        row.add(new Object[]{this.td(new Object[]{cell}).attribute("style", "width: 100%")});
        cell.add(new Object[]{this.span(new Object[]{descriptor.getName()}).cssClass("ci-property-name")});
        cell.add(new Object[]{this.span(new Object[]{": "})});
        Element kind = this.span(new Object[]{descriptor.getKind()}).cssClass("ci-property-kind");
        cell.add(new Object[]{kind});
        if (descriptor.getKind() == PropertyKind.ENUM) {
            kind.add(new Object[]{" ", Arrays.toString(descriptor.getEnumValues().toArray())});
        }
        if (descriptor.getKind() == PropertyKind.CI || descriptor.getKind() == PropertyKind.SET_OF_CI || descriptor.getKind() == PropertyKind.LIST_OF_CI) {
            kind.add(new Object[]{"&lt;", this.render(descriptor.getReferencedType()), "&gt;"});
        }
        if (descriptor.getDefaultValue() != null) {
            cell.add(new Object[]{"&nbsp;=&nbsp;"});
            cell.add(new Object[]{this.span(new Object[]{descriptor.getDefaultValue()}).cssClass("ci-property-default")});
        }
        return row;
    }

    private Element getRequiredIcon(PropertyDescriptor descriptor) {
        Element icon = this.div(new Object[]{"&nbsp;"}).cssClass("icon");
        if (descriptor.isRequired()) {
            icon.cssClass("icon required").attribute("title", "Required property");
        }
        return icon;
    }

    private Element getInspectionIcon(PropertyDescriptor descriptor) {
        Element icon = this.div(new Object[]{"&nbsp;"}).cssClass("icon");
        if (descriptor.isInspectionProperty()) {
            if (descriptor.isRequiredForInspection()) {
                icon.cssClass("icon inspection-required").attribute("title", "Inspection property (required)");
            } else {
                icon.cssClass("icon inspection").attribute("title", "Inspection property");
            }
        }
        return icon;
    }

    private Element getPropertyDescriptionRow(PropertyDescriptor descriptor) {
        return this.row(new Object[]{"", "", this.div(new Object[]{descriptor.getDescription()}).cssClass("ci-property-desc")});
    }

    public void startControlTask(String category) {
        this.table(new Object[0]).cssClass("ci-properties").writeOpen();
        this.rowHeader(new Object[]{category}).cssClass("odd ci-prop-header").write();
    }

    public void endControlTask() {
        this.table(new Object[0]).writeClose();
    }

    public void controlTaskMethod(MethodDescriptor method, int row) {
        this.row(new Object[]{this.anchor(method.getFqn().replace('.', '_'), new Object[0]), this.span(new Object[]{method.getName()}).cssClass("ci-property-name"), this.p(new Object[]{method.getDescription()}).cssClass("ci-property-desc")}).cssClass(row % 2 == 0 ? "even" : "odd").write();
    }

    public void categoryHeader(String category) {
        this.h3(new Object[]{category}).cssClass("ci-toc-category").write();
    }

    public void setCis(List<Descriptor> cis) {
        this.typesInDocument = Sets.newLinkedHashSet();
        for (Descriptor ci : cis) {
            this.typesInDocument.add(ci.getType());
        }
    }

    public void startDocument() {
        this.html(new Object[0]).writeOpen();
        this.head(new Object[]{this.title("CI Reference"), this.linkCss("deployit.css"), this.linkCss("ci-reference-api.css")}).write();
        this.body(new Object[0]).writeOpen();
    }

    public void endDocument() {
        this.body(new Object[0]).writeClose();
        this.html(new Object[0]).writeClose();
    }
}

