/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WkhtmlPdfGenerator {
    private URL coverHtml;
    private URL footerHtml;
    private URL headerHtml;
    private URL tocXsl;
    private String wkHtmlToPdfCommand = "wkhtmltopdf";
    private PrintStream processOutputStream = System.out;
    private ContextProperties properties = new ContextProperties();
    private File workingDir;
    private Map<URL, File> tempFileCache = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(WkhtmlPdfGenerator.class);

    public File generatePdfFromHtml(File html) {
        Preconditions.checkArgument((this.workingDir != null ? 1 : 0) != 0, (Object)"Working directory must be provided.");
        String config = IOUtils.extractFileNameWithoutExtension(html);
        File pdf = IOUtils.createFileNameWithNewExtension(html, this.workingDir, "pdf");
        logger.info("Creating pdf '{}' from from html source '{}'.", (Object)pdf, (Object)html);
        ContextProperties placeholderValues = this.preparePlaceholderValues(config);
        ArrayList command = Lists.newArrayList();
        command.add(this.wkHtmlToPdfCommand);
        ArrayList tempFiles = Lists.newArrayList();
        command.add("--disable-javascript");
        command.add("--image-dpi");
        command.add("1024");
        command.add("--margin-bottom");
        command.add("12");
        command.add("--print-media-type");
        tempFiles.add(this.processOption(command, "html", placeholderValues, this.headerHtml, "--header-html"));
        tempFiles.add(this.processOption(command, "html", placeholderValues, this.footerHtml, "--footer-html"));
        tempFiles.add(this.processOption(command, "html", placeholderValues, this.coverHtml, "cover"));
        tempFiles.add(this.processOption(command, "xsl", placeholderValues, this.tocXsl, "toc", "--xsl-style-sheet"));
        command.add(html.getAbsolutePath());
        command.add(pdf.getAbsolutePath());
        this.executeWkhtmlCommand(command);
        WkhtmlPdfGenerator.deleteTempFiles(tempFiles);
        return pdf;
    }

    private ContextProperties preparePlaceholderValues(String config) {
        ContextProperties values = new ContextProperties();
        values.putAll((Map)((Object)this.properties));
        String docName = values.get(config + ".title", config);
        values.put("title", docName);
        return values;
    }

    private File processOption(List<String> cmd, String fileExt, ContextProperties values, URL url, String ... options) {
        if (url != null) {
            File file = this.createFileForUrlWithPlaceholdersReplaced(url, values, fileExt);
            cmd.addAll(Arrays.asList(options));
            cmd.add(file.getAbsolutePath());
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileForUrlWithPlaceholdersReplaced(URL url, ContextProperties values, String fileExt) {
        try {
            File target = this.downloadUrl(url, fileExt);
            File placeholderReplacedTarget = this.createTempFile(fileExt);
            FileWriter fw = new FileWriter(placeholderReplacedTarget);
            FileReader fr = new FileReader(target);
            try {
                IOUtils.replacePlaceholders(fr, values, fw);
            }
            finally {
                Closeables.closeQuietly((Closeable)fw);
                Closeables.closeQuietly((Closeable)fr);
            }
            return placeholderReplacedTarget;
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private File downloadUrl(URL url, String fileExt) throws IOException {
        if (this.tempFileCache.containsKey(url)) {
            return this.tempFileCache.get(url);
        }
        File tempFile = this.createTempFile(fileExt);
        IOUtils.copy(url, tempFile);
        this.tempFileCache.put(url, tempFile);
        return tempFile;
    }

    private static void deleteTempFiles(Collection<File> tempFiles) {
        for (File file : tempFiles) {
            if (file == null) continue;
            file.delete();
        }
    }

    public void clearTemporaryFiles() {
        WkhtmlPdfGenerator.deleteTempFiles(this.tempFileCache.values());
    }

    private File createTempFile(String ext) throws IOException {
        return File.createTempFile("deployit", "." + ext, this.workingDir);
    }

    private void executeWkhtmlCommand(List<String> command) {
        try {
            int rc = this.executeCommand(command.toArray(new String[command.size()]));
            if (rc != 0) {
                throw new RuntimeException("Failed to generate pdf. Return code '" + rc + "' from executing : " + command);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private int executeCommand(String[] command) throws IOException {
        String line;
        ProcessBuilder probuilder = new ProcessBuilder(command);
        probuilder.redirectErrorStream(true);
        probuilder.directory(this.workingDir);
        logger.info("Executing command {}", (Object)Joiner.on((char)' ').join((Object[])command));
        Process process = probuilder.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = br.readLine()) != null) {
            logger.debug(line);
            if (line.startsWith("[")) continue;
            this.processOutputStream.println(line);
        }
        try {
            int exitValue = process.waitFor();
            return exitValue;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            logger.error("Error while waiting for command", (Throwable)e);
            return 1;
        }
    }

    public void setCoverHtml(URL coverHtml) {
        this.coverHtml = coverHtml;
    }

    public void setFooterHtml(URL footerHtml) {
        this.footerHtml = footerHtml;
    }

    public void setHeaderHtml(URL headerHtml) {
        this.headerHtml = headerHtml;
    }

    public void setTocXsl(URL tocXsl) {
        this.tocXsl = tocXsl;
    }

    public void setWkHtmlToPdfCommand(String wkHtmlToPdfCommand) {
        this.wkHtmlToPdfCommand = wkHtmlToPdfCommand;
    }

    public void setProcessOutputStream(PrintStream processOutputStream) {
        this.processOutputStream = processOutputStream;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public void setProperties(ContextProperties properties) {
        this.properties = properties;
    }
}

